/* ------------------------------------------------------------------------------
*
*  # Fixed Columns extension for Datatables
*
*  Specific JS code additions for datatable_extension_fixed_columns.html page
*
*  Version: 1.0
*  Latest update: Aug 1, 2015
*
* ---------------------------------------------------------------------------- */

$(function() {


    // Table setup
    // ------------------------------

    // Setting datatable defaults
    $.extend( $.fn.dataTable.defaults, {
        columnDefs: [{ 
            orderable: false,
            width: '100px',
            targets: [ 5 ]
        }],
        dom: '<"datatable-scroll datatable-scroll-wrap"t>',
        language: {
            search: '<span>Filter:</span> _INPUT_',
            lengthMenu: '<span>Show:</span> _MENU_',
            paginate: { 'first': 'First', 'last': 'Last', 'next': '&rarr;', 'previous': '&larr;' }
        }
    });


    

    // Left and right fixed columns
    $('.datatable-fixed-both').DataTable({
        paging: false,
		columnDefs: [
            
            { 
                width: "80px",
                targets: [0]
            },
            { 
                width: "100px",
                targets: [1,2]
            },
            { 
                width: "80px",
                targets: [5]
            },
            { 
                width: "40px",
                targets: [3,4]
            }
        ],
        scrollX: true,
        scrollY: '500px',
        scrollCollapse: true
    });





    // External table additions
    // ------------------------------

    // Add placeholder to the datatable filter option
    $('.dataTables_filter input[type=search]').attr('placeholder','Type to filter...');


    // Enable Select2 select for the length option
    $('.dataTables_length select').select2({
        minimumResultsForSearch: "-1"
    });
	
	
	
	
	
	// function to initiate Validation Sample 1
   
    
});
