/* ------------------------------------------------------------------------------
 *
 *  # Echarts - lines and areas
 *
 *  Lines and areas chart configurations
 *
 *  Version: 1.0
 *  Latest update: August 1, 2015
 *
 * ---------------------------------------------------------------------------- */

$(function() {



function padDigits(number, digits) {
     	return Array(Math.max(digits - String(number).length + 1, 0)).join(0) + number;
	 }

			
function NamaMeterku(meterku) {
		
		document.getElementById("namameter").innerHTML  = meterku;
	}
	
function IDMeterku(idmeterku) {
		
		document.getElementById("meterid").value = idmeterku;
	}   
		

function getQueryVariable(variable)
{
       var query = window.location.search.substring(1);
       var vars = query.split("&");
       for (var i=0;i<vars.length;i++) {
               var pair = vars[i].split("=");
               if(pair[0] == variable){return pair[1];}
       }
       return(false);
}
		

 		 
    // Set paths
    // ------------------------------

    require.config({
        paths: {
            echarts: 'assets/vendor/echarts'
        }
    });


    // Configuration
    // ------------------------------

    require(
        [
            'echarts',
            'echarts/theme/limitless',
            'echarts/chart/bar',
            'echarts/chart/line'
        ],


        // Charts setup
        function (ec, limitless) {


            // Initialize charts
            // ------------------------------

            var basic_lines = ec.init(document.getElementById('basic_lines'), limitless);



            // Charts setup
            // ------------------------------

            //
            // Basic lines options
            //
			
			
			
function TrendGrafik(link, datapost) {
			
   
   $.ajax({
       url: link,
       type:"post",
       data:datapost,
       success: function(data) {

			//alert(data);
			
			databaru = JSON.parse(data);	
			// document.getElementById("test").innerHTML = data;
			// document.getElementById("test1").innerHTML = databaru.panel;
			
			// var parameter = databaru[1].datagrf;
			
			
			
			// document.getElementById("test").innerHTML = jmlgrf;
			
	
			basic_lines_options = {

                title: {
        		 	x: 'center',
					y: 0,
        			text: databaru.panel + ' : Mode ' + databaru.mode  + ' : Date ' + databaru.dateselected,
        			subtext: databaru.hari
    			},
				// Setup grid
                grid: {
                    y: 70,
                    y2: 80
                },

                // Add tooltip
                tooltip: {
                    trigger: 'axis'
                },
				
    			toolbox: {
        			show : true,
        			feature : {
            			mark : {
							   	show: false,
							   	title : {
            						  mark : 'Mark',
            						  markUndo : 'Undo',
            						  markClear : 'Clear'
        							  }
								},
						
    					dataZoom : {
        						show : true,
        						title : {
            						  dataZoom : 'Zoom',
            						  dataZoomReset : 'Zoom Reset'
        							  }
    							},
            			dataView : {
														
								show: false, 
								readOnly: false,
								title : 'Data View',
								lang: ['Data View', 'Close', 'Copy']
								},
            			magicType : {
								show: true, 
								type: ['line', 'bar'],
								title : {
            						  line : 'Line',
            						  bar : 'Bar'
        							  }
								},
            			restore : {
								show: true,
        						title : 'Restore'
								
								},
            			saveAsImage : {
								show: true,
        						title : 'Save as Image'
								
								}
        			}
    			},

                // Add legend
                legend: {
                    data: ['kWh per Jam'],
					x: 'center',
					y: 'bottom'
                },

                // Add custom colors
                color: ['#EF5350'],

                // Enable drag recalculate
                calculable: true,

                // Horizontal axis
                xAxis: [{
                    type: 'category',
					name: 'Jam',
                    boundaryGap: false,
                    data: databaru.jam,
                    
                }],

                // Vertical axis
                yAxis: [{
                    type: 'value',
					name: 'kWh',
                    axisLabel: {
                        formatter: '{value} '
                    }
                }],

                
			
				// Add series
                series: [
                
				   
					
					{
                        name: 'kWh per Jam',
                        type: 'line',
                        // data: databaru[4].datagrf,
						data: databaru.kwh,
            			markPoint : {
                			data : [
                    		 	 {type : 'max', name: 'Maximum'},
                    		 	 {type : 'min', name: 'Minimum'}
                			 ]
            			}
                    }
				 
					
					
                ]
            };
			
			basic_lines.setOption(basic_lines_options);
			
			
			
			
				
					
        },
			
        error: function(errmsg) {
                // alert("Ajax??????????!"+ errmsg);
        }
   });	
			
			

}

function CekData(link, datapost) {
			
   var dataHome = "";
   $.ajax({
       url: link,
       type:"post",
       data:datapost,
       success: function(data) {
           		
			databaru = JSON.parse(data);	
			
			
			
			
				
					
        },
			
        error: function(errmsg) {
                //alert("Ajax??????????!"+ errmsg);
        }
   });	
			

}


var meterid 	  	= $("#meterid").val();
var metername 	  	= $("#meterid option:selected").text();
var mode 	  		= $("#mode").val();	
var dateselected 	= $("#dateselected").val();			
var linkku   	  = 'kwhperjam/datagrafik';
var dataposku 	  = "id="+escape(meterid)+"&mode="+escape(mode)+"&dateselected="+escape(dateselected);

NamaMeterku(metername);
TrendGrafik(linkku, dataposku);


			$("#meterid").change(function(e){
					var meterid2 		= $("#meterid").val();
					var metername2 		= $("#meterid option:selected").text();
					var mode2 			= $("#mode").val();
					var dateselected2 	= $("#dateselected").val();	
					var linkku2   		= 'kwhperjam/datagrafik';
					var dataposku2  	= "id="+escape(meterid2)+"&mode="+escape(mode2)+"&dateselected="+escape(dateselected2);
					NamaMeterku(metername2);
					TrendGrafik(linkku2, dataposku2);
        	});

			$("#mode").change(function(e){
					var meterid2 		= $("#meterid").val();
					var metername2 		= $("#meterid option:selected").text();
					var mode2 			= $("#mode").val();
					var dateselected2 	= $("#dateselected").val();	
					var linkku2   		= 'kwhperjam/datagrafik';
					var dataposku2  	= "id="+escape(meterid2)+"&mode="+escape(mode2)+"&dateselected="+escape(dateselected2);
					NamaMeterku(metername2);
					TrendGrafik(linkku2, dataposku2);
        	});

			$("#dateselected").change(function(e){
					var meterid2 		= $("#meterid").val();
					var metername2 		= $("#meterid option:selected").text();
					var mode2 			= $("#mode").val();
					var dateselected2 	= $("#dateselected").val();	
					var linkku2   		= 'kwhperjam/datagrafik';
					var dataposku2  	= "id="+escape(meterid2)+"&mode="+escape(mode2)+"&dateselected="+escape(dateselected2);
					NamaMeterku(metername2);
					TrendGrafik(linkku2, dataposku2);
        	});









            //
           

            // Apply options
            // ------------------------------

            



            // Resize charts
            // ------------------------------

            window.onresize = function () {
                setTimeout(function () {
                    basic_lines.resize();
                }, 200);
            }
        }
    );
});
