<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Kwhperjam extends CI_Controller {

	function __construct(){
		parent::__construct();		
		$this->load->model(array('model_kwhperjam', 'mcrud'));
		if($this->session->userdata('id_jenis_user') <> '1')
		{
			redirect('login');
		}
	}
	
    public function index() {
		$d['title'] = 'kwhperjam';
		$d['judul'] = 'Login Multiuser Codeigniter dengan Mysql';
		$d['username'] = $this->session->userdata('username');
		$d['level'] = $this->session->userdata('level');
		$d['nama'] = $this->session->userdata('nama');
		$d['email'] = $this->session->userdata('email');
		$d['avatar'] = $this->session->userdata('avatar');
		$d['background'] = $this->session->userdata('background');
		$d['page'] = 'admin';	
		$d['data_meter'] = $this->model_kwhperjam->getdata('data_meter')->result();
		$d['parameter'] = $this->model_kwhperjam->getdata('parameter')->result();
		
		$d['dateselected'] = date('Y-m-d');
		
        $this->template->display('kwhperjam',$d);
    }
	
	
	
	
	public function datagrafik()
	{
        $id 			= $this->input->post('id');
		$mode 			= $this->input->post('mode');
		$dateselected	= $this->input->post('dateselected');
		
		// $id = 'PANEL BELAKANG';
		//$id = 'Panel-01';
		if ($dateselected == '') {
			$dateselected = date('Y-m-d');
		}
		
		//$hari   	= date('Y-m-d');
		$hari   	= $dateselected;
		$jam		= array();
		$kwh		= array();
		$databaru 	= array();
		
		
		
		$val_kwh_last 	= 0;
		$no 			= 0;
		
    	while($no<24){
    	   if($no<10){
    	   		$nj = '0'.$no;
    	   }
    	   else{
    	   		$nj = $no;
    	   }
    	   
		   $list = $this->model_kwhperjam->id_jam($id, $hari, $nj)->result();
		   
		   
		   if($list=='' or $list==null){
		   		$kwh[] = '0';
				//$kwh[] = number_format( ($val_kwh_last / 1000), 2);
				$jam[] = $nj;
				
				if ($mode == '') {
					$mode = 'Cummulative';
				}
		   }
		   else{
				if ($mode == 'Difference') {
					$dt_now  = $this->model_kwhperjam->data_jam($id, $hari, $nj)->row();
					$kwh_now = $dt_now->kwh_exp;
					if ($kwh_now == '') $kwh_now = 0;
					
					
					if ($no == 0) {
						$hari_before 	= date('Y-m-d', strtotime($hari . " -1 days"));
						$nj_before 		= '23';
					} else {
						$hari_before 	= $hari;
						
						if($no<10){
							$nj_before = '00';
				    	} else {
							$nj_before = '' . $no - 1 . '';
						}
					}
					
					$dt_before_list = $this->model_kwhperjam->id_jam($id, $hari_before, $nj_before)->result();
					if($dt_before_list=='' or $dt_before_list==null){
						$kwh_before = 0;
					} else {
						$dt_before  = $this->model_kwhperjam->data_jam($id, $hari_before, $nj_before)->row();
						$kwh_before = $dt_before->kwh_exp;
						if ($kwh_before == '') $kwh_before = 0;
					}
					
					$diff_kwh = $kwh_now - $kwh_before;
					
					$kwh[] = number_format( ($diff_kwh / 1000), 2);
					$jam[] = $nj;
				} else {
					$dtku  		= $this->model_kwhperjam->data_jam($id, $hari, $nj)->row();
					$val_kwh 	= $dtku->kwh_exp;
					if ($val_kwh > 0) {
						$val_kwh_last = $val_kwh;
					} else {
						//$val_kwh = $val_kwh_last;
					}
					
					$kwh[] 		= number_format( ($val_kwh / 1000), 2);
					$jam[] 		= $nj;
					
					if ($mode == '') {
						$mode = 'Cummulative';
					}
				}
		   		
		   }
		   
		   
		   
		   
    	   $no++;
    	
    	}
		
       	$databaru['panel'] 			= $this->mcrud->getvalue('data_meter', 'id_name', 'id', $id);
		$databaru['mode'] 			= $mode;
		$databaru['dateselected'] 	= $dateselected;
       	$databaru['jam']   			= $jam;
       	$databaru['kwh']   			= $kwh;
		
		//$column = '[0,3,4,7,8,9,10]';
		//$output[]['dataku'] = $data;
		//$output[]['dataku'] = $column;
		//output to json format
		echo json_encode($databaru);
		       
	}


}