<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Alarm extends CI_Controller {

	function __construct(){
		parent::__construct();		
		$this->load->model('model_alarm');
		if($this->session->userdata('id_jenis_user') <> '1')
		{
			redirect('login');
		}
	}
	
    public function index() {
		$d['title'] = 'ALARM';
		$d['judul'] = 'Login Multiuser Codeigniter dengan Mysql';
		$d['username'] = $this->session->userdata('username');
		$d['level'] = $this->session->userdata('level');
		$d['nama'] = $this->session->userdata('nama');
		$d['email'] = $this->session->userdata('email');
		$d['avatar'] = $this->session->userdata('avatar');
		$d['background'] = $this->session->userdata('background');
		$d['page'] = 'admin';		
		$d['data_log'] = $this->model_alarm->getdata('tabel_log')->result();		
		$d['data_teg'] = $this->model_alarm->getdata('data_meter')->result();
        $this->template->display('alarm',$d);
    }

	public function alarmhistory() {
		$d['title'] = 'ALARM';
		$d['judul'] = 'Login Multiuser Codeigniter dengan Mysql';
		$d['username'] = $this->session->userdata('username');
		$d['level'] = $this->session->userdata('level');
		$d['nama'] = $this->session->userdata('nama');
		$d['email'] = $this->session->userdata('email');
		$d['avatar'] = $this->session->userdata('avatar');
		$d['background'] = $this->session->userdata('background');
		$d['page'] = 'admin';		
		$d['data_log'] = $this->model_alarm->getdata('tabel_log')->result();		
		$d['data_teg'] = $this->model_alarm->getdata('data_meter')->result();
        $this->template->display('alarmhistory',$d);
    }

	public function ajax_list()
	{
		//$list = $this->person->get_datatables();
		
		$var_date_from	= date('Y-m-1');
		$var_date_thru	= date('Y-m-t');
		//$var_shownumber = 'ALL';
		$var_shownumber = 100;
		$var_active 	= 1;
		
		$list = $this->model_alarm->tampil($var_date_from, $var_date_thru, $var_shownumber, $var_active)->result();
		$data = array();
		$no = 0;
		foreach ($list as $alarm) {
			$no++;
			$row = array();
			$row[] = $alarm->id_alarm;
			$row[] = $alarm->id_name;
			$row[] = $alarm->id_meter;
			$row[] = $alarm->date_time;
			$row[] = $alarm->alarmlog;
			$row[] = '';
			$row[] = '';
			

			//add html for action
			$row[] = '';
		
			$data[] = $row;
		}

		$output = array($data
				);
		//output to json format
		echo json_encode($data);
	}
	
	public function ajax_list_history()
	{
		//$list = $this->person->get_datatables();
		
		$var_date_from	= date('Y-m-1');
		$var_date_thru	= date('Y-m-t');
		//$var_shownumber = 'ALL';
		$var_shownumber = 100;
		$var_active 	= 'ALL';
		
		$list = $this->model_alarm->tampil($var_date_from, $var_date_thru, $var_shownumber, $var_active)->result();
		$data = array();
		$no = 0;
		foreach ($list as $alarm) {
			$no++;
			$row = array();
			$row[] = $alarm->id_alarm;
			$row[] = $alarm->id;
			$row[] = $alarm->id_serial;
			$row[] = $alarm->date_time;
			$row[] = $alarm->alarmlog;
			$row[] = '';
			$row[] = '';
			

			//add html for action
			$row[] = '';
		
			$data[] = $row;
		}

		$output = array($data
				);
		//output to json format
		echo json_encode($data);
	}	
	
	public function pushdataalarm()
	{

		$var_date_from	= date('Y-m-1');
		$var_date_thru	= date('Y-m-t');
		$var_shownumber = 5;
		$var_active 	= 1;
		
		$list = $this->model_alarm->tampil($var_date_from, $var_date_thru, $var_shownumber, $var_active)->result();
		$data = array();
		
		$no 				= 0;
		$alarm_description 	= '';
		
		foreach ($list as $alarm) {
			$no++;

			$alarm_description .= '<b>' . $alarm->id_name . '</b>';
			$alarm_description .= '<br><b>' . $alarm->date_time . '</b>';
			$alarm_description .= '<br>' . $alarm->alarmlog;
			$alarm_description .= '<br><br>';
		}
		
		if ($no > 0) {
			$alarm_link = "<a href='" . base_url() . "alarm'>Show All Alarm</a>";
		} else {
			$alarm_link = "";
			$alarm_description = 'No alarm.';
		}

		$data = array();
		$row = array();
		
		$row['alarm_description']  	= $alarm_description;
		$row['alarm_link']  		= $alarm_link;
		
		$data[] = $row;
		
		$output = array($data
				);
		//output to json format
		echo json_encode($data);
	}

}